package gov.va.med.mhv.sm.api.common;


import gov.va.med.mhv.sm.api.exception.SMSException;
import gov.va.med.mhv.sm.api.transfer.FolderTO;
import gov.va.med.mhv.sm.api.transfer.FoldersTO;
import gov.va.med.mhv.sm.api.transfer.MessagesTO;

import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

import org.springframework.stereotype.Service;

@Consumes({"application/xml","application/json"})
@Produces({"application/xml","application/json"})


@Service("folderApiService")
public interface FolderAPIService {
    
	@GET
	@Path("/folder/")
	public FoldersTO getFolders();

	@GET
	@Path("/folder/{folderId}")
	public FolderTO getFolder( @javax.ws.rs.PathParam("folderId") Long folderId ) throws SMSException;

	@GET
	@Path("/folder/{folderId}/message/page/{pageNumber}/pageSize/{pageSize}")
	public MessagesTO getMessagesForFolder(@javax.ws.rs.PathParam("folderId") Long folderId,
											@javax.ws.rs.PathParam("pageNumber") Long pageNumber, @javax.ws.rs.PathParam("pageSize") Long pageSize) throws SMSException;

	@POST
	@Path("/folder")
	public FolderTO createFolder( FolderTO folder ) throws SMSException;

	@POST
	@Path("/folder/{folderId}/rename/{folderName}")
	public FolderTO renameFolder(@javax.ws.rs.PathParam("folderId") Long folderId, @javax.ws.rs.PathParam("folderName") String folderName) throws SMSException;

	@POST
	@Path("/folder/{folderId}/rename")
	public FolderTO update(@javax.ws.rs.PathParam("folderId") Long folderId, String folderName)  throws SMSException;

	
	@DELETE
	@Path("/folder/{folderId}")
	public Response deleteFolder(@javax.ws.rs.PathParam("folderId") Long folderId) throws SMSException;

//	@GET
//	@Path("/folder/{folderId}/message/page/{pageNumber}/pageSize/{pageSize}/sort/{sortField}/order/{sortOrder}")
//	public MessagesTO getMessagesForFolder(@javax.ws.rs.PathParam("folderId") Long folderId, @javax.ws.rs.PathParam("pageNumber") Long pageNumber, @javax.ws.rs.PathParam("pageSize") Long pageSize, @javax.ws.rs.PathParam("sortField") MessagesOrderByEnum sortField, @javax.ws.rs.PathParam("sortOrder") SortOrderEnum sortOrder) throws SMSException;

//	@POST
//	@Path("/folder/{folderId}/searchMessage/page/{pageNumber}/pageSize/{pageSize}")
//	public MessagesTO searchForMessagesInFolder(@javax.ws.rs.PathParam("folderId") Long folderId, @javax.ws.rs.PathParam("pageNumber") Long pageNumber, @javax.ws.rs.PathParam("pageSize") Long pageSize, MessageSearchFormTO searchForm) throws SMSException;
	
}
